-- Short Lua script for calculating coupling factor of two coils.
-- It presumes the problem is already defined in FEMM, and
-- that the two windings are defined by circuits named "pri" and "sec".
-- The problem may be DC or AC at a frequency of your choice.
-- Intended for circuits with series property.
-- Execute with the FEMM menu item File/OpenLuaScript.
clearconsole()
showconsole()

-- mi_modifycircprop takes three parameters
-- 1st = circuit name to be changed, 2nd = 1 = change current value, 3rd = new current value (A)
-- change the curent value to your own, here it is assume that prim=0.01A, sec=10.0A

-- Simulate first with only secondary current:
mi_modifycircprop("pri", 1, 0)   
mi_modifycircprop("sec", 1, 10)   -- change "10" to your own I2 in "sec"
mi_analyze()
mi_loadsolution()
print(mo_getcircuitproperties("sec"))  -- Optional display of intermediate results
print(mo_getcircuitproperties("pri"))  -- Optional display of intermediate results
i, Vsec, Lsec = mo_getcircuitproperties("sec") 			-- extract inductance
i, Vpri_sec, Lpri_sec = mo_getcircuitproperties("pri")	-- extract inductance

-- Simulate next with only primary current:
mi_modifycircprop("pri", 1, 0.01)   -- change "0.01" to your own I1 in "prim"
mi_modifycircprop("sec", 1, 0)
mi_analyze()
mi_loadsolution()
print(mo_getcircuitproperties("sec"))  -- Optional display of intermediate results
print(mo_getcircuitproperties("pri"))  -- Optional display of intermediate results
i, Vsec_pri, Lsec_pri = mo_getcircuitproperties("sec")   -- extract inductance
i, Vpri, Lpri = mo_getcircuitproperties("pri")    		 -- extract inductance

-- Calculate and print coupling factor:
coupling_factor = sqrt(Lsec_pri * Lpri_sec / (Lpri * Lsec))
print("Coupling factor is:", coupling_factor) 